appModule.controller('CoverCtrl', ["api",  "$scope", "$timeout",'utils','pages','log',"$translate","notices", function(api,$scope, $timeout,utils,pages,log,translate,notices) {
    $scope.windowName = "cover";
    $scope.defaultImageWidth = 142;//封面图宽度
    $scope.timeoutPromise = null;
    $scope.init = function(){
        $scope.selectedCover=null;
        $scope.cropper = {};
        api.getNoticeCovers(function(data){
            if(!Array.isArray(data)){
                return;
            }
            utils.applyScope($scope,function(){
                $scope.defaultCoverCategories = $scope.replaceNameAndLocalImage(data);
                $scope.selectCategory(0);
            });

        },function(msg){
            log.logInfo("failed to load covers");
        });
    };

    $scope.replaceNameAndLocalImage = function(data){
      for(var i=0;i<data.length;i++){
          data[i].type_name = translate.instant('publish.default-covers.'+data[i].type_name);
          for(var j=0;j<data[i].lists.length;j++){
              var url = data[i].lists[j].url?data[i].lists[j].url:data[i].lists[j];
              var cropUrl = notices.modifyImageURL(url,$scope.defaultImageWidth);
              var localUrl = notices.getDataFromLocalDB(cropUrl);
              if(localUrl && utils.isFileExist(localUrl)){
                  data[i].lists[j] = {
                      id:data[i].lists[j].id,
                      url:localUrl,
                      remoteUrl:url
                  }
              }else{
                  if(!data[i].lists[j].url){
                      data[i].lists[j] = {
                          id:data[i].lists[j].id,
                          url:cropUrl,
                          remoteUrl:url
                      };
                  }else{
                      data[i].lists[j].url = cropUrl;
                  }
              }
          }
      }
        return data;
    };


    $scope.selectCategory = function(index){
        $scope.selectedCategory = $scope.defaultCoverCategories[index];
        if($scope.timeoutPromise){
            $timeout.cancel($scope.timeoutPromise);
        }
        $scope.timeoutPromise = $timeout(function(){
            for(var i=0; i<$scope.selectedCategory.lists.length;i++){
                downloadCover($scope.selectedCategory.lists[i].url);
            }
        });
    };

    $scope.selectCover = function(index){
        if($scope.selectedCover== $scope.selectedCategory.lists[index]) {
            $scope.selectedCover = null;
            return;
        }
        $scope.selectedCover = $scope.selectedCategory.lists[index];
    };
    $scope.cancelUpload= function(){
        $scope.tempCover = "";
        $scope.toggleCoverOptionDialog();
    };

    $scope.saveCover = function() {
        var path = $scope.tempCover.replace(/%25/gm,'%').replace(/%23/gm,'#').replace(/%2B/gm,'+').replace(/%26/gm,'&');
        var tempCover = path.replace(/\?rnd=.*/g,'');
        var suffixIndex = tempCover.lastIndexOf(".");
        var suffix = "";
        if(suffixIndex > -1){
            suffix = tempCover.substr(suffixIndex);
        }
        var tempCroppedPath = ucClient.ClientService.getDocumentDataDirSync(3) + '/cropped/temp_notice_'+Date.now()+suffix;
        var path = $scope.cropper.crop(tempCroppedPath);
        log.logInfo("notice cover cropped path:"+path);
        $scope.toggleCoverOptionDialog();
        $scope.showLoading = true;
        $scope.startFileUpload(path,function(errorCode,data){
            $scope.showLoading = false;
            if(errorCode !== 0){
                api.notifyError(translate.instant("publish.alert.upload-image-failed"));
            } else{
                utils.deleteFile(path);
                api.uploadCustomizedCover(data,function(){
                    $scope.defaultCoverCategories[$scope.defaultCoverCategories.length-1].lists.push(data);
                    $scope.onClose();
                },function(msg){
                    api.notifyError(msg);
                    log.logInfo("failed to upload customized cover: " + msg);
                });
            }
        });
    };

    $scope.onClose =function(){
        $scope.closeCover();
    };

    $scope.onSave = function() {
        if(!$scope.selectedCover){
            $scope.onClose();
        }else{
            $scope.selectNewCover($scope.selectedCover);
            $scope.onClose();
        }
    };
    $scope.removeCustomCover = function(index, cover,e){
        if(!cover.id){
            var option = {
                msg:translate.instant("publish.alert.remove-custom-cover"),
                onConfirm:function(){
            $scope.selectedCategory.lists.splice(index,1);
                },
                onCancel:null,
                isShowCancel:true
            };
            api.notifyError(option);
            return;
        }
        e.stopPropagation();
        var option = {
            msg:translate.instant("publish.alert.remove-custom-cover"),
            onConfirm:function(){
            api.removeNoticeCovers(cover.id,function(){
                utils.applyScope($scope,function(){
                    $scope.selectedCategory.lists.splice(index,1);
                });
            },function(msg){
                log.logInfo("delete custom cover failed:"+JSON.stringify(cover));
            });
            },
            onCancel:null,
            isShowCancel:true
        };
        api.notifyError(option);
    };
    $scope.toggleCoverOptionDialog = function() {
        $scope.showCoverOptions = !$scope.showCoverOptions;
    };
    $scope.showCoverOptionDialog = function() {
        $scope.showCoverOptions = true;
    };
    $scope.updateCover = function() {
        utils.openImageDialog(function(data) {
            if (data.errorCode == 0) {
                utils.applyScope($scope, function() {
                    var path = data.paths[0].replace(/\%/gm,'%25').replace(/\#/gm,'%23').replace(/\+/gm,'%2B').replace(/\&/gm,'%26');
                    $scope.tempCover = path+"?rnd="+Math.random();
                    $scope.showCoverOptionDialog();
                });
            } else {
                api.notifyError(data.msg);
            }
        });
    };
    $scope.init();

    function downloadCover(url){
        if(url.startsWith("http")){
            pages.triggerCrossWindowEvent("OnRequestStoreCover",{"path":url});
        }
    }
}]);
